<?php
/**
 * Data Insert Script
 * Generated from local database: mikhmon_agents
 * Generated: 2025-11-06 09:04:43
 */

// This file will be included in install_database.php
// $pdo variable is available from parent script

// ========================================
// INSERT DATA FOR TABLE: agents
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into agents...</div>";
    $pdo->exec("DELETE FROM `agents`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `agents` (`id`, `agent_code`, `agent_name`, `phone`, `email`, `password`, `balance`, `status`, `level`, `commission_percent`, `created_by`, `created_at`, `updated_at`, `last_login`, `notes`) VALUES (:id, :agent_code, :agent_name, :phone, :email, :password, :balance, :status, :level, :commission_percent, :created_by, :created_at, :updated_at, :last_login, :notes)");

    $stmt->execute([
        ':id' => '1',
        ':agent_code' => 'AG001',
        ':agent_name' => 'Agent Demo',
        ':phone' => '081234567890',
        ':email' => 'agent@demo.com',
        ':password' => '$2y$10$fScZJVBJmYn9IKNw6ReXq.z5QJ62M1GM11yxSt.r7fwBXXbO7Xre.',
        ':balance' => '150000.00',
        ':status' => 'active',
        ':level' => 'silver',
        ':commission_percent' => '5.00',
        ':created_by' => 'admin',
        ':created_at' => '2025-11-01 02:27:19',
        ':updated_at' => '2025-11-05 07:32:25',
        ':last_login' => '2025-11-05 07:20:41',
        ':notes' => '',
    ]);
    $stmt->execute([
        ':id' => '2',
        ':agent_code' => 'AG5136',
        ':agent_name' => 'tester',
        ':phone' => '083149850493',
        ':email' => 'alijaya@gmail.com',
        ':password' => '$2y$10$GTBERFO2gGBchTdhfmp1sezZ5xP7qrPsAIn4x.BecAMOsnYKlOCmO',
        ':balance' => '148000.00',
        ':status' => 'active',
        ':level' => 'bronze',
        ':commission_percent' => '5.00',
        ':created_by' => 'alijaya',
        ':created_at' => '2025-11-01 07:13:29',
        ':updated_at' => '2025-11-05 07:06:31',
        ':last_login' => '2025-11-05 07:06:31',
        ':notes' => '',
    ]);
    $stmt->execute([
        ':id' => '3',
        ':agent_code' => 'PUBLIC',
        ':agent_name' => 'Public Catalog',
        ':phone' => '000',
        ':email' => '',
        ':password' => '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
        ':balance' => '0.00',
        ':status' => 'active',
        ':level' => 'silver',
        ':commission_percent' => '0.00',
        ':created_by' => 'system',
        ':created_at' => '2025-11-04 20:34:58',
        ':updated_at' => '2025-11-04 20:34:58',
        ':last_login' => null,
        ':notes' => null,
    ]);

    echo "<div class='success'>✅ Inserted 3 records into agents</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into agents: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: agent_settings
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into agent_settings...</div>";
    $pdo->exec("DELETE FROM `agent_settings`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `agent_settings` (`id`, `setting_key`, `setting_value`, `setting_type`, `description`, `updated_at`, `updated_by`) VALUES (:id, :setting_key, :setting_value, :setting_type, :description, :updated_at, :updated_by)");

    $stmt->execute([
        ':id' => '1',
        ':setting_key' => 'min_topup_amount',
        ':setting_value' => '50000',
        ':setting_type' => 'number',
        ':description' => 'Minimum amount untuk topup saldo',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '2',
        ':setting_key' => 'max_topup_amount',
        ':setting_value' => '10000000',
        ':setting_type' => 'number',
        ':description' => 'Maximum amount untuk topup saldo',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '3',
        ':setting_key' => 'auto_approve_topup',
        ':setting_value' => '0',
        ':setting_type' => 'boolean',
        ':description' => 'Auto approve topup request',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '4',
        ':setting_key' => 'commission_enabled',
        ':setting_value' => '1',
        ':setting_type' => 'boolean',
        ':description' => 'Enable commission system',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '5',
        ':setting_key' => 'default_commission_percent',
        ':setting_value' => '5',
        ':setting_type' => 'number',
        ':description' => 'Default commission percentage',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '6',
        ':setting_key' => 'agent_registration_enabled',
        ':setting_value' => '1',
        ':setting_type' => 'boolean',
        ':description' => 'Allow agent self registration',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '7',
        ':setting_key' => 'min_balance_alert',
        ':setting_value' => '10000',
        ':setting_type' => 'number',
        ':description' => 'Alert when balance below this amount',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '8',
        ':setting_key' => 'whatsapp_notification_enabled',
        ':setting_value' => '1',
        ':setting_type' => 'boolean',
        ':description' => 'Send WhatsApp notification to agents',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '9',
        ':setting_key' => 'agent_can_set_sell_price',
        ':setting_value' => '1',
        ':setting_type' => 'boolean',
        ':description' => 'Allow agent to set their own sell price',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '10',
        ':setting_key' => 'voucher_prefix_agent',
        ':setting_value' => 'AG',
        ':setting_type' => 'string',
        ':description' => 'Prefix for agent generated vouchers',
        ':updated_at' => '2025-11-01 02:23:26',
        ':updated_by' => null,
    ]);
    $stmt->execute([
        ':id' => '51',
        ':setting_key' => 'voucher_username_password_same',
        ':setting_value' => '1',
        ':setting_type' => 'boolean',
        ':description' => 'Username dan password sama atau berbeda',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '52',
        ':setting_key' => 'voucher_username_type',
        ':setting_value' => 'numeric',
        ':setting_type' => 'string',
        ':description' => 'Tipe karakter username: numeric, alpha, alphanumeric',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '53',
        ':setting_key' => 'voucher_username_length',
        ':setting_value' => '5',
        ':setting_type' => 'number',
        ':description' => 'Panjang karakter username',
        ':updated_at' => '2025-11-05 05:11:13',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '54',
        ':setting_key' => 'voucher_password_type',
        ':setting_value' => 'alphanumeric',
        ':setting_type' => 'string',
        ':description' => 'Tipe karakter password: numeric, alpha, alphanumeric',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '55',
        ':setting_key' => 'voucher_password_length',
        ':setting_value' => '6',
        ':setting_type' => 'number',
        ':description' => 'Panjang karakter password',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '56',
        ':setting_key' => 'voucher_prefix_enabled',
        ':setting_value' => '0',
        ':setting_type' => 'boolean',
        ':description' => 'Gunakan prefix untuk username',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '57',
        ':setting_key' => 'voucher_prefix',
        ':setting_value' => 'AG',
        ':setting_type' => 'string',
        ':description' => 'Prefix untuk username',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '58',
        ':setting_key' => 'voucher_uppercase',
        ':setting_value' => '1',
        ':setting_type' => 'boolean',
        ':description' => 'Gunakan huruf kapital',
        ':updated_at' => '2025-11-01 03:36:45',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '83',
        ':setting_key' => 'admin_whatsapp_numbers',
        ':setting_value' => '6281947215703',
        ':setting_type' => 'string',
        ':description' => 'Admin WhatsApp numbers for unlimited voucher generation',
        ':updated_at' => '2025-11-05 11:41:56',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '93',
        ':setting_key' => 'wa_message_header',
        ':setting_value' => '╔═══════════════════╗
║  🎫 ALIJAYA WIFI ║
╚═══════════════════╝',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 07:15:27',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '94',
        ':setting_key' => 'wa_message_footer',
        ':setting_value' => '━━━━━━━━━━━━━━━━━━━━
📞 Customer Service
WA: {business_phone}
📍 {business_address}

Terima kasih! 🙏',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 04:07:14',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '95',
        ':setting_key' => 'wa_business_name',
        ':setting_value' => 'ALIJAYA Hotspot',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 04:07:14',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '96',
        ':setting_key' => 'wa_business_phone',
        ':setting_value' => '081947215703',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 04:07:14',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '97',
        ':setting_key' => 'wa_business_address',
        ':setting_value' => 'Jl. Pantai Tanjungpura Desa Ujunggebang',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 04:07:14',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '98',
        ':setting_key' => 'wa_enable_emoji',
        ':setting_value' => '1',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 04:07:14',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '99',
        ':setting_key' => 'wa_enable_formatting',
        ':setting_value' => '1',
        ':setting_type' => 'string',
        ':description' => 'WhatsApp message setting',
        ':updated_at' => '2025-11-01 04:07:14',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '132',
        ':setting_key' => 'payment_bank_name',
        ':setting_value' => 'BRI',
        ':setting_type' => 'string',
        ':description' => 'Payment information setting',
        ':updated_at' => '2025-11-04 09:26:57',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '133',
        ':setting_key' => 'payment_account_number',
        ':setting_value' => '420601003953531',
        ':setting_type' => 'string',
        ':description' => 'Payment information setting',
        ':updated_at' => '2025-11-04 09:26:57',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '134',
        ':setting_key' => 'payment_account_name',
        ':setting_value' => 'WARJAYA',
        ':setting_type' => 'string',
        ':description' => 'Payment information setting',
        ':updated_at' => '2025-11-04 09:26:57',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '135',
        ':setting_key' => 'payment_wa_confirm',
        ':setting_value' => '081947215703',
        ':setting_type' => 'string',
        ':description' => 'Payment information setting',
        ':updated_at' => '2025-11-04 09:26:57',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '136',
        ':setting_key' => 'public_duration_v15',
        ':setting_value' => '7d',
        ':setting_type' => 'string',
        ':description' => 'Public catalog duration',
        ':updated_at' => '2025-11-04 21:18:29',
        ':updated_by' => 'admin',
    ]);
    $stmt->execute([
        ':id' => '137',
        ':setting_key' => 'public_duration_3k',
        ':setting_value' => '1d',
        ':setting_type' => 'string',
        ':description' => 'Public catalog duration',
        ':updated_at' => '2025-11-04 21:19:31',
        ':updated_by' => 'admin',
    ]);

    echo "<div class='success'>✅ Inserted 32 records into agent_settings</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into agent_settings: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: agent_prices
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into agent_prices...</div>";
    $pdo->exec("DELETE FROM `agent_prices`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `agent_prices` (`id`, `agent_id`, `profile_name`, `buy_price`, `sell_price`, `stock_limit`, `created_at`, `updated_at`) VALUES (:id, :agent_id, :profile_name, :buy_price, :sell_price, :stock_limit, :created_at, :updated_at)");

    $stmt->execute([
        ':id' => '1',
        ':agent_id' => '1',
        ':profile_name' => '3k',
        ':buy_price' => '2000.00',
        ':sell_price' => '3000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-01 03:04:08',
        ':updated_at' => '2025-11-01 03:04:08',
    ]);
    $stmt->execute([
        ':id' => '2',
        ':agent_id' => '1',
        ':profile_name' => '5k',
        ':buy_price' => '4000.00',
        ':sell_price' => '5000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-01 03:04:21',
        ':updated_at' => '2025-11-01 03:04:21',
    ]);
    $stmt->execute([
        ':id' => '3',
        ':agent_id' => '2',
        ':profile_name' => '3k',
        ':buy_price' => '2000.00',
        ':sell_price' => '3000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-01 07:14:02',
        ':updated_at' => '2025-11-01 07:14:02',
    ]);
    $stmt->execute([
        ':id' => '4',
        ':agent_id' => '2',
        ':profile_name' => '5k',
        ':buy_price' => '4000.00',
        ':sell_price' => '5000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-01 07:14:16',
        ':updated_at' => '2025-11-01 07:14:16',
    ]);
    $stmt->execute([
        ':id' => '5',
        ':agent_id' => '2',
        ':profile_name' => '10k',
        ':buy_price' => '8000.00',
        ':sell_price' => '10000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-01 07:14:28',
        ':updated_at' => '2025-11-01 07:14:28',
    ]);
    $stmt->execute([
        ':id' => '7',
        ':agent_id' => '3',
        ':profile_name' => '3k',
        ':buy_price' => '0.00',
        ':sell_price' => '3000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 20:34:58',
        ':updated_at' => '2025-11-04 20:34:58',
    ]);
    $stmt->execute([
        ':id' => '8',
        ':agent_id' => '3',
        ':profile_name' => '5k',
        ':buy_price' => '0.00',
        ':sell_price' => '5000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 20:35:27',
        ':updated_at' => '2025-11-04 20:35:27',
    ]);
    $stmt->execute([
        ':id' => '9',
        ':agent_id' => '3',
        ':profile_name' => '10k',
        ':buy_price' => '0.00',
        ':sell_price' => '10000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 20:37:18',
        ':updated_at' => '2025-11-04 20:37:18',
    ]);
    $stmt->execute([
        ':id' => '10',
        ':agent_id' => '3',
        ':profile_name' => '15k',
        ':buy_price' => '0.00',
        ':sell_price' => '15000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 20:37:29',
        ':updated_at' => '2025-11-04 20:37:29',
    ]);
    $stmt->execute([
        ':id' => '11',
        ':agent_id' => '3',
        ':profile_name' => '25k',
        ':buy_price' => '0.00',
        ':sell_price' => '25000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 20:37:38',
        ':updated_at' => '2025-11-04 20:37:38',
    ]);
    $stmt->execute([
        ':id' => '12',
        ':agent_id' => '3',
        ':profile_name' => '50k',
        ':buy_price' => '0.00',
        ':sell_price' => '50000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 20:37:50',
        ':updated_at' => '2025-11-04 20:37:50',
    ]);
    $stmt->execute([
        ':id' => '13',
        ':agent_id' => '3',
        ':profile_name' => 'v15',
        ':buy_price' => '0.00',
        ':sell_price' => '15000.00',
        ':stock_limit' => '0',
        ':created_at' => '2025-11-04 21:18:29',
        ':updated_at' => '2025-11-04 21:18:29',
    ]);

    echo "<div class='success'>✅ Inserted 12 records into agent_prices</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into agent_prices: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: agent_transactions
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into agent_transactions...</div>";
    $pdo->exec("DELETE FROM `agent_transactions`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `agent_transactions` (`id`, `agent_id`, `transaction_type`, `amount`, `balance_before`, `balance_after`, `profile_name`, `voucher_username`, `voucher_password`, `quantity`, `description`, `reference_id`, `created_by`, `created_at`, `ip_address`, `user_agent`) VALUES (:id, :agent_id, :transaction_type, :amount, :balance_before, :balance_after, :profile_name, :voucher_username, :voucher_password, :quantity, :description, :reference_id, :created_by, :created_at, :ip_address, :user_agent)");

    $stmt->execute([
        ':id' => '1',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '100000.00',
        ':balance_after' => '98000.00',
        ':profile_name' => '3k',
        ':voucher_username' => 'AG6Ye4kcJ8',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: AG6Ye4kcJ8',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:08:11',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '2',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '4000.00',
        ':balance_before' => '98000.00',
        ':balance_after' => '94000.00',
        ':profile_name' => '5k',
        ':voucher_username' => 'AG4SBeNWSH',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: AG4SBeNWSH',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:09:44',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '3',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '94000.00',
        ':balance_after' => '92000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '802954',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 802954',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:37:03',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '4',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '92000.00',
        ':balance_after' => '90000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '409463',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 409463',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:41:34',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '5',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '90000.00',
        ':balance_after' => '88000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '416135',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 416135',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:41:53',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '6',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '88000.00',
        ':balance_after' => '86000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '142643',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 142643',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:44:58',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '7',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '86000.00',
        ':balance_after' => '84000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '603672',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 603672',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:49:11',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '8',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '4000.00',
        ':balance_before' => '84000.00',
        ':balance_after' => '80000.00',
        ':profile_name' => '5k',
        ':voucher_username' => '620868',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 620868',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 03:49:59',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '9',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '4000.00',
        ':balance_before' => '80000.00',
        ':balance_after' => '76000.00',
        ':profile_name' => '5k',
        ':voucher_username' => '008851',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 008851',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 04:20:18',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '10',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '76000.00',
        ':balance_after' => '74000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '981271',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 981271',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 04:20:42',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '11',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '74000.00',
        ':balance_after' => '72000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '73869360',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 73869360',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 04:27:14',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '12',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '72000.00',
        ':balance_after' => '70000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '43217291',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 43217291',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 06:32:52',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '13',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '70000.00',
        ':balance_after' => '68000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '42126512',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 42126512',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 06:33:30',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '14',
        ':agent_id' => '1',
        ':transaction_type' => 'topup',
        ':amount' => '100000.00',
        ':balance_before' => '68000.00',
        ':balance_after' => '168000.00',
        ':profile_name' => null,
        ':voucher_username' => null,
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => '',
        ':reference_id' => null,
        ':created_by' => 'alijaya',
        ':created_at' => '2025-11-01 07:12:34',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '15',
        ':agent_id' => '2',
        ':transaction_type' => 'topup',
        ':amount' => '50000.00',
        ':balance_before' => '100000.00',
        ':balance_after' => '150000.00',
        ':profile_name' => null,
        ':voucher_username' => null,
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => '',
        ':reference_id' => null,
        ':created_by' => 'alijaya',
        ':created_at' => '2025-11-01 07:15:40',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '16',
        ':agent_id' => '2',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '150000.00',
        ':balance_after' => '148000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '053893',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 053893',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-01 07:16:47',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '17',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '168000.00',
        ':balance_after' => '166000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '831366',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 831366',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-04 10:47:25',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '18',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '166000.00',
        ':balance_after' => '164000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '265403',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 265403',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-04 10:50:04',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '19',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '164000.00',
        ':balance_after' => '162000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '046700',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 046700',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-04 10:51:39',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '20',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '162000.00',
        ':balance_after' => '160000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '65390',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 65390',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-05 07:21:37',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '21',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '160000.00',
        ':balance_after' => '158000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '52599',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 52599',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-05 07:32:24',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '22',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '158000.00',
        ':balance_after' => '156000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '70892',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 70892',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-05 07:32:24',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '23',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '156000.00',
        ':balance_after' => '154000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '99618',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 99618',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-05 07:32:24',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '24',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '154000.00',
        ':balance_after' => '152000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '54228',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 54228',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-05 07:32:25',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);
    $stmt->execute([
        ':id' => '25',
        ':agent_id' => '1',
        ':transaction_type' => 'generate',
        ':amount' => '2000.00',
        ':balance_before' => '152000.00',
        ':balance_after' => '150000.00',
        ':profile_name' => '3k',
        ':voucher_username' => '83888',
        ':voucher_password' => null,
        ':quantity' => '1',
        ':description' => 'Generate voucher: 83888',
        ':reference_id' => null,
        ':created_by' => null,
        ':created_at' => '2025-11-05 07:32:25',
        ':ip_address' => null,
        ':user_agent' => null,
    ]);

    echo "<div class='success'>✅ Inserted 25 records into agent_transactions</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into agent_transactions: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: payment_gateway_config
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into payment_gateway_config...</div>";
    $pdo->exec("DELETE FROM `payment_gateway_config`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `payment_gateway_config` (`id`, `gateway_name`, `is_active`, `is_sandbox`, `api_key`, `api_secret`, `merchant_code`, `callback_token`, `config_json`, `created_at`, `updated_at`) VALUES (:id, :gateway_name, :is_active, :is_sandbox, :api_key, :api_secret, :merchant_code, :callback_token, :config_json, :created_at, :updated_at)");

    $stmt->execute([
        ':id' => '1',
        ':gateway_name' => 'tripay',
        ':is_active' => '1',
        ':is_sandbox' => '1',
        ':api_key' => 'DEV-0MGDWCoixR7pZjA8xqDKbbBn3A7lHQopEUUlqFO4',
        ':api_secret' => 'CjcVY-mSvfi-o4DSf-x1c0q-ONNrt',
        ':merchant_code' => 'T34280',
        ':callback_token' => '',
        ':config_json' => null,
        ':created_at' => '2025-11-05 20:59:27',
        ':updated_at' => '2025-11-06 08:06:28',
    ]);

    echo "<div class='success'>✅ Inserted 1 records into payment_gateway_config</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into payment_gateway_config: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: agent_profile_pricing
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into agent_profile_pricing...</div>";
    $pdo->exec("DELETE FROM `agent_profile_pricing`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `agent_profile_pricing` (`id`, `agent_id`, `profile_name`, `display_name`, `description`, `price`, `original_price`, `is_active`, `is_featured`, `icon`, `color`, `user_type`, `sort_order`, `created_at`, `updated_at`) VALUES (:id, :agent_id, :profile_name, :display_name, :description, :price, :original_price, :is_active, :is_featured, :icon, :color, :user_type, :sort_order, :created_at, :updated_at)");

    $stmt->execute([
        ':id' => '1',
        ':agent_id' => '1',
        ':profile_name' => '3k',
        ':display_name' => 'Voucher 1 Hari',
        ':description' => 'Kecepatan Upto 2Mbps
Tanpa Batas Kuota',
        ':price' => '3000.00',
        ':original_price' => '0.00',
        ':is_active' => '1',
        ':is_featured' => '0',
        ':icon' => 'fa-wifi',
        ':color' => 'blue',
        ':user_type' => 'voucher',
        ':sort_order' => '0',
        ':created_at' => '2025-11-05 20:53:45',
        ':updated_at' => '2025-11-05 20:54:23',
    ]);
    $stmt->execute([
        ':id' => '2',
        ':agent_id' => '1',
        ':profile_name' => '5k',
        ':display_name' => 'Voucher 2 Hari',
        ':description' => 'Kecepatan Upto 2Mbps
Tanpa Batas Kuota',
        ':price' => '5000.00',
        ':original_price' => '0.00',
        ':is_active' => '1',
        ':is_featured' => '0',
        ':icon' => 'fa-wifi',
        ':color' => 'green',
        ':user_type' => 'voucher',
        ':sort_order' => '0',
        ':created_at' => '2025-11-05 20:55:20',
        ':updated_at' => '2025-11-05 20:55:20',
    ]);
    $stmt->execute([
        ':id' => '3',
        ':agent_id' => '1',
        ':profile_name' => '10k',
        ':display_name' => 'Voucher 5 Hari',
        ':description' => 'Kecepatan Upto 2Mbps
Tanpa Batas Kuota',
        ':price' => '10000.00',
        ':original_price' => '0.00',
        ':is_active' => '1',
        ':is_featured' => '0',
        ':icon' => 'fa-wifi',
        ':color' => 'red',
        ':user_type' => 'voucher',
        ':sort_order' => '0',
        ':created_at' => '2025-11-05 20:55:54',
        ':updated_at' => '2025-11-05 20:55:54',
    ]);
    $stmt->execute([
        ':id' => '4',
        ':agent_id' => '1',
        ':profile_name' => '15k',
        ':display_name' => 'Voucher 7 Hari',
        ':description' => 'Kecepatan Upto 2Mbps
Tanpa Batas Kuota',
        ':price' => '15000.00',
        ':original_price' => '0.00',
        ':is_active' => '1',
        ':is_featured' => '0',
        ':icon' => 'fa-wifi',
        ':color' => 'yellow',
        ':user_type' => 'voucher',
        ':sort_order' => '0',
        ':created_at' => '2025-11-05 20:56:19',
        ':updated_at' => '2025-11-05 20:56:19',
    ]);
    $stmt->execute([
        ':id' => '5',
        ':agent_id' => '1',
        ':profile_name' => '25k',
        ':display_name' => 'Voucher 15 Hari',
        ':description' => 'Kecepatan Upto 2Mbps
Tanpa Batas Kuota',
        ':price' => '25000.00',
        ':original_price' => '0.00',
        ':is_active' => '1',
        ':is_featured' => '0',
        ':icon' => 'fa-wifi',
        ':color' => 'aqua',
        ':user_type' => 'voucher',
        ':sort_order' => '0',
        ':created_at' => '2025-11-05 20:56:47',
        ':updated_at' => '2025-11-05 20:56:47',
    ]);
    $stmt->execute([
        ':id' => '11',
        ':agent_id' => '1',
        ':profile_name' => '50k',
        ':display_name' => 'Voucher 30 Hari',
        ':description' => 'Kecepatan Upto 2Mbps
Tanpa Batas Kuota',
        ':price' => '50000.00',
        ':original_price' => '60000.00',
        ':is_active' => '1',
        ':is_featured' => '0',
        ':icon' => 'fa-wifi',
        ':color' => 'blue',
        ':user_type' => 'voucher',
        ':sort_order' => '0',
        ':created_at' => '2025-11-06 10:26:14',
        ':updated_at' => '2025-11-06 10:26:14',
    ]);

    echo "<div class='success'>✅ Inserted 6 records into agent_profile_pricing</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into agent_profile_pricing: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: public_sales
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into public_sales...</div>";
    $pdo->exec("DELETE FROM `public_sales`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `public_sales` (`id`, `transaction_id`, `payment_reference`, `agent_id`, `profile_id`, `customer_name`, `customer_phone`, `customer_email`, `profile_name`, `price`, `admin_fee`, `total_amount`, `gateway_name`, `payment_method`, `payment_channel`, `payment_url`, `qr_url`, `virtual_account`, `payment_instructions`, `expired_at`, `paid_at`, `status`, `voucher_code`, `voucher_password`, `voucher_generated_at`, `voucher_sent_at`, `ip_address`, `user_agent`, `callback_data`, `notes`, `created_at`, `updated_at`) VALUES (:id, :transaction_id, :payment_reference, :agent_id, :profile_id, :customer_name, :customer_phone, :customer_email, :profile_name, :price, :admin_fee, :total_amount, :gateway_name, :payment_method, :payment_channel, :payment_url, :qr_url, :virtual_account, :payment_instructions, :expired_at, :paid_at, :status, :voucher_code, :voucher_password, :voucher_generated_at, :voucher_sent_at, :ip_address, :user_agent, :callback_data, :notes, :created_at, :updated_at)");

    $stmt->execute([
        ':id' => '1',
        ':transaction_id' => 'TRX-1762351252-51647',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '2',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '5k',
        ':price' => '5000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '5000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-05 21:00:52',
        ':updated_at' => '2025-11-05 21:00:52',
    ]);
    $stmt->execute([
        ':id' => '2',
        ':transaction_id' => 'TRX-1762390891-32996',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:01:31',
        ':updated_at' => '2025-11-06 08:01:31',
    ]);
    $stmt->execute([
        ':id' => '3',
        ':transaction_id' => 'TRX-1762390953-93620',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:02:33',
        ':updated_at' => '2025-11-06 08:02:33',
    ]);
    $stmt->execute([
        ':id' => '4',
        ':transaction_id' => 'TRX-1762391207-81467',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:06:47',
        ':updated_at' => '2025-11-06 08:06:47',
    ]);
    $stmt->execute([
        ':id' => '5',
        ':transaction_id' => 'TRX-1762391571-92850',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '1',
        ':customer_name' => 'Test Customer',
        ':customer_phone' => '628123456789',
        ':customer_email' => 'test@example.com',
        ':profile_name' => '3k',
        ':price' => '3000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '3000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:12:51',
        ':updated_at' => '2025-11-06 08:12:51',
    ]);
    $stmt->execute([
        ':id' => '6',
        ':transaction_id' => 'TRX-1762391670-53155',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '1',
        ':customer_name' => 'Test Customer',
        ':customer_phone' => '628123456789',
        ':customer_email' => 'test@example.com',
        ':profile_name' => '3k',
        ':price' => '3000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '3000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:14:30',
        ':updated_at' => '2025-11-06 08:14:30',
    ]);
    $stmt->execute([
        ':id' => '7',
        ':transaction_id' => 'TRX-1762391681-77458',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:14:41',
        ':updated_at' => '2025-11-06 08:14:41',
    ]);
    $stmt->execute([
        ':id' => '8',
        ':transaction_id' => 'TRX-1762391936-71628',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '1',
        ':customer_name' => 'Test Customer',
        ':customer_phone' => '628123456789',
        ':customer_email' => 'test@example.com',
        ':profile_name' => '3k',
        ':price' => '3000.00',
        ':admin_fee' => '2.50',
        ':total_amount' => '3002.50',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'SHOPEEPAY',
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:18:56',
        ':updated_at' => '2025-11-06 08:24:35',
    ]);
    $stmt->execute([
        ':id' => '9',
        ':transaction_id' => 'TRX-1762392371-19108',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '2.50',
        ':total_amount' => '10002.50',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'OVO',
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:26:11',
        ':updated_at' => '2025-11-06 08:26:20',
    ]);
    $stmt->execute([
        ':id' => '10',
        ':transaction_id' => 'TRX-1762392558-41855',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:29:18',
        ':updated_at' => '2025-11-06 08:29:18',
    ]);
    $stmt->execute([
        ':id' => '11',
        ':transaction_id' => 'TRX-1762392580-64562',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:29:40',
        ':updated_at' => '2025-11-06 08:29:40',
    ]);
    $stmt->execute([
        ':id' => '12',
        ':transaction_id' => 'TRX-1762392787-99957',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '0.00',
        ':total_amount' => '10000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => null,
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:33:07',
        ':updated_at' => '2025-11-06 08:33:07',
    ]);
    $stmt->execute([
        ':id' => '13',
        ':transaction_id' => 'TRX-1762392850-22223',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '2.50',
        ':total_amount' => '10002.50',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'OVO',
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:34:10',
        ':updated_at' => '2025-11-06 08:34:17',
    ]);
    $stmt->execute([
        ':id' => '14',
        ':transaction_id' => 'TRX-1762392996-39586',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '2.50',
        ':total_amount' => '10002.50',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'DANA',
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:36:36',
        ':updated_at' => '2025-11-06 08:36:40',
    ]);
    $stmt->execute([
        ':id' => '15',
        ':transaction_id' => 'TRX-1762393171-83612',
        ':payment_reference' => 'DEV-T34280306409IC5UT',
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '2500.00',
        ':total_amount' => '12500.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'ALFAMART',
        ':payment_channel' => 'ALFAMART',
        ':payment_url' => 'https://tripay.co.id/checkout/DEV-T34280306409IC5UT',
        ':qr_url' => null,
        ':virtual_account' => '629391358383011',
        ':payment_instructions' => null,
        ':expired_at' => '2025-11-07 02:38:39',
        ':paid_at' => '2025-11-06 02:45:25',
        ':status' => 'paid',
        ':voucher_code' => '37355',
        ':voucher_password' => '37355',
        ':voucher_generated_at' => '2025-11-06 08:45:29',
        ':voucher_sent_at' => '2025-11-06 08:45:29',
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => '{\"reference\":\"DEV-T34280306409IC5UT\",\"merchant_ref\":\"INV-1762393180-5462\",\"payment_method\":\"ALFAMART\",\"payment_method_code\":\"ALFAMART\",\"total_amount\":12500,\"fee_merchant\":2500,\"fee_customer\":0,\"total_fee\":2500,\"amount_received\":10000,\"is_closed\":1,\"status\":\"PAID\",\"paid_at\":\"2025-11-06 02:45:25\",\"note\":\"Payment successful via Alfamart - TEST SIMULATION\"}',
        ':notes' => null,
        ':created_at' => '2025-11-06 08:39:31',
        ':updated_at' => '2025-11-06 08:45:29',
    ]);
    $stmt->execute([
        ':id' => '16',
        ':transaction_id' => 'TRX-1762393868-64511',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '2.50',
        ':total_amount' => '10002.50',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'DANA',
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Mobile Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:51:08',
        ':updated_at' => '2025-11-06 08:51:16',
    ]);
    $stmt->execute([
        ':id' => '17',
        ':transaction_id' => 'TRX-1762394026-71253',
        ':payment_reference' => 'DEV-T34280306411DDSKH',
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '250.00',
        ':total_amount' => '10250.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'DANA',
        ':payment_channel' => 'DANA',
        ':payment_url' => 'https://tripay.co.id/checkout/DEV-T34280306411DDSKH',
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => '2025-11-06 03:52:54',
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 08:53:46',
        ':updated_at' => '2025-11-06 08:53:55',
    ]);
    $stmt->execute([
        ':id' => '18',
        ':transaction_id' => 'TRX-1762394447-25989',
        ':payment_reference' => 'DEV-T34280306413AKCAI',
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'ALIJAYA JURAGAN PULSA',
        ':customer_phone' => '6287947215703',
        ':customer_email' => 'teates@gmaial.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '250.00',
        ':total_amount' => '10250.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'OVO',
        ':payment_channel' => 'OVO',
        ':payment_url' => 'https://tripay.co.id/checkout/DEV-T34280306413AKCAI',
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => '2025-11-07 03:00:57',
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.180',
        ':user_agent' => 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Mobile Safari/537.36',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 09:00:47',
        ':updated_at' => '2025-11-06 09:00:57',
    ]);
    $stmt->execute([
        ':id' => '19',
        ':transaction_id' => 'TRX-1762395025-96585',
        ':payment_reference' => null,
        ':agent_id' => '1',
        ':profile_id' => '3',
        ':customer_name' => 'ALIJAYA JURAGAN PULSA',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijaya@gmail.com',
        ':profile_name' => '10k',
        ':price' => '10000.00',
        ':admin_fee' => '4000.00',
        ':total_amount' => '14000.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'MYBVA',
        ':payment_channel' => null,
        ':payment_url' => null,
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => null,
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '192.168.8.180',
        ':user_agent' => 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Mobile Safari/537.36',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 09:10:25',
        ':updated_at' => '2025-11-06 09:10:31',
    ]);
    $stmt->execute([
        ':id' => '21',
        ':transaction_id' => 'TRX-1762414139-37578',
        ':payment_reference' => 'DEV-T34280306491WDTRP',
        ':agent_id' => '1',
        ':profile_id' => '2',
        ':customer_name' => 'juragan alijaya',
        ':customer_phone' => '6281947215703',
        ':customer_email' => 'alijayanet@gmail.com',
        ':profile_name' => '5k',
        ':price' => '5000.00',
        ':admin_fee' => '125.00',
        ':total_amount' => '5125.00',
        ':gateway_name' => 'tripay',
        ':payment_method' => 'DANA',
        ':payment_channel' => 'DANA',
        ':payment_url' => 'https://tripay.co.id/checkout/DEV-T34280306491WDTRP',
        ':qr_url' => null,
        ':virtual_account' => null,
        ':payment_instructions' => null,
        ':expired_at' => '2025-11-06 09:29:07',
        ':paid_at' => null,
        ':status' => 'pending',
        ':voucher_code' => null,
        ':voucher_password' => null,
        ':voucher_generated_at' => null,
        ':voucher_sent_at' => null,
        ':ip_address' => '::1',
        ':user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0',
        ':callback_data' => null,
        ':notes' => null,
        ':created_at' => '2025-11-06 14:28:59',
        ':updated_at' => '2025-11-06 14:30:09',
    ]);

    echo "<div class='success'>✅ Inserted 20 records into public_sales</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into public_sales: " . $e->getMessage() . "</div>";
}

// ========================================
// INSERT DATA FOR TABLE: payment_methods
// ========================================
try {
    echo "<div class='info'>📊 Inserting data into payment_methods...</div>";
    $pdo->exec("DELETE FROM `payment_methods`"); // Clear existing data

    $stmt = $pdo->prepare("INSERT INTO `payment_methods` (`id`, `gateway_name`, `method_code`, `method_name`, `method_type`, `icon_url`, `admin_fee_type`, `admin_fee_value`, `min_amount`, `max_amount`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES (:id, :gateway_name, :method_code, :method_name, :method_type, :icon_url, :admin_fee_type, :admin_fee_value, :min_amount, :max_amount, :is_active, :sort_order, :created_at, :updated_at)");

    $stmt->execute([
        ':id' => '1',
        ':gateway_name' => 'tripay',
        ':method_code' => 'MYBVA',
        ':method_name' => 'Maybank Virtual Account',
        ':method_type' => 'bank_transfer',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '4000.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '50000000.00',
        ':is_active' => '1',
        ':sort_order' => '1',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '2',
        ':gateway_name' => 'tripay',
        ':method_code' => 'PERMATAVA',
        ':method_name' => 'Permata Virtual Account',
        ':method_type' => 'bank_transfer',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '4000.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '50000000.00',
        ':is_active' => '1',
        ':sort_order' => '2',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '3',
        ':gateway_name' => 'tripay',
        ':method_code' => 'BNIVA',
        ':method_name' => 'BNI Virtual Account',
        ':method_type' => 'bank_transfer',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '4000.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '50000000.00',
        ':is_active' => '1',
        ':sort_order' => '3',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '4',
        ':gateway_name' => 'tripay',
        ':method_code' => 'BRIVA',
        ':method_name' => 'BRI Virtual Account',
        ':method_type' => 'bank_transfer',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '4000.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '50000000.00',
        ':is_active' => '1',
        ':sort_order' => '4',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '5',
        ':gateway_name' => 'tripay',
        ':method_code' => 'MANDIRIVA',
        ':method_name' => 'Mandiri Virtual Account',
        ':method_type' => 'bank_transfer',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '4000.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '50000000.00',
        ':is_active' => '1',
        ':sort_order' => '5',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '6',
        ':gateway_name' => 'tripay',
        ':method_code' => 'BCAVA',
        ':method_name' => 'BCA Virtual Account',
        ':method_type' => 'bank_transfer',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '4000.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '50000000.00',
        ':is_active' => '1',
        ':sort_order' => '6',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '7',
        ':gateway_name' => 'tripay',
        ':method_code' => 'SHOPEEPAY',
        ':method_name' => 'ShopeePay',
        ':method_type' => 'ewallet',
        ':icon_url' => null,
        ':admin_fee_type' => 'percentage',
        ':admin_fee_value' => '2.50',
        ':min_amount' => '1000.00',
        ':max_amount' => '20000000.00',
        ':is_active' => '1',
        ':sort_order' => '10',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:18:00',
    ]);
    $stmt->execute([
        ':id' => '8',
        ':gateway_name' => 'tripay',
        ':method_code' => 'OVO',
        ':method_name' => 'OVO',
        ':method_type' => 'ewallet',
        ':icon_url' => null,
        ':admin_fee_type' => 'percentage',
        ':admin_fee_value' => '2.50',
        ':min_amount' => '1000.00',
        ':max_amount' => '10000000.00',
        ':is_active' => '1',
        ':sort_order' => '11',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '9',
        ':gateway_name' => 'tripay',
        ':method_code' => 'DANA',
        ':method_name' => 'DANA',
        ':method_type' => 'ewallet',
        ':icon_url' => null,
        ':admin_fee_type' => 'percentage',
        ':admin_fee_value' => '2.50',
        ':min_amount' => '1000.00',
        ':max_amount' => '20000000.00',
        ':is_active' => '1',
        ':sort_order' => '12',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:18:00',
    ]);
    $stmt->execute([
        ':id' => '10',
        ':gateway_name' => 'tripay',
        ':method_code' => 'LINKAJA',
        ':method_name' => 'LinkAja',
        ':method_type' => 'ewallet',
        ':icon_url' => null,
        ':admin_fee_type' => 'percentage',
        ':admin_fee_value' => '2.50',
        ':min_amount' => '1000.00',
        ':max_amount' => '10000000.00',
        ':is_active' => '1',
        ':sort_order' => '13',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:18:00',
    ]);
    $stmt->execute([
        ':id' => '11',
        ':gateway_name' => 'tripay',
        ':method_code' => 'GOPAY',
        ':method_name' => 'GoPay',
        ':method_type' => 'ewallet',
        ':icon_url' => null,
        ':admin_fee_type' => 'percentage',
        ':admin_fee_value' => '2.50',
        ':min_amount' => '1000.00',
        ':max_amount' => '20000000.00',
        ':is_active' => '1',
        ':sort_order' => '14',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:18:00',
    ]);
    $stmt->execute([
        ':id' => '12',
        ':gateway_name' => 'tripay',
        ':method_code' => 'ALFAMART',
        ':method_name' => 'Alfamart',
        ':method_type' => 'retail',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '2500.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '2500000.00',
        ':is_active' => '1',
        ':sort_order' => '20',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '13',
        ':gateway_name' => 'tripay',
        ':method_code' => 'INDOMARET',
        ':method_name' => 'Indomaret',
        ':method_type' => 'retail',
        ':icon_url' => null,
        ':admin_fee_type' => 'flat',
        ':admin_fee_value' => '2500.00',
        ':min_amount' => '1000.00',
        ':max_amount' => '5000000.00',
        ':is_active' => '1',
        ':sort_order' => '21',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:28:04',
    ]);
    $stmt->execute([
        ':id' => '14',
        ':gateway_name' => 'tripay',
        ':method_code' => 'QRIS',
        ':method_name' => 'QRIS (Scan to Pay)',
        ':method_type' => 'qris',
        ':icon_url' => null,
        ':admin_fee_type' => 'percentage',
        ':admin_fee_value' => '0.70',
        ':min_amount' => '1000.00',
        ':max_amount' => '10000000.00',
        ':is_active' => '1',
        ':sort_order' => '30',
        ':created_at' => '2025-11-06 08:18:00',
        ':updated_at' => '2025-11-06 08:18:00',
    ]);

    echo "<div class='success'>✅ Inserted 14 records into payment_methods</div>";
} catch (PDOException $e) {
    echo "<div class='warning'>⚠️ Error inserting data into payment_methods: " . $e->getMessage() . "</div>";
}

echo "<div class='success'>🎉 All data inserted successfully! Total records: 113</div>";
?>